clearvars
c_parameters_immune_oned

L=10;
T_pde=1000;
maxit=1;
delta=0.05; %mm
tau=0.01; %h
dx=0.05;
dt=1e-3;
cell_uninf=Ru; %larghezza iniziale dominio non infetto
cell_inf=Ri;   %largezza iniziale dominio infetto
h_uninf=0.9*K;
h_inf=0.1*K;
%save('c_parameters')

space=[-L L];

chiT=chiT/10;
zU=zU/2;
zI=zI/2;
q=q/5;
S_z=0.05;


tic
c_pde_immune_oned
time_pde=toc
% save('pde','u1','u2','u3','u4','x','t','dx','dt','time_pde')
%%
tic
seed=1;
rng(seed)
c_agents_immune_oned
time_agents=toc
% save('agents'+string(seed),'U','I','Tcell','c','seed','time_agents')

%%

U_plot=U;
I_plot=I;
Tcell_plot=Tcell;
c_plot=c;

h = figure(1); clf
vid=VideoWriter('video');
% vid=VideoWriter('/fred/oz055/david/2023/immune/v_${SLURM_JOB_NAME}_${SLURM_ARRAY_JOB_ID}_${SLURM_ARRAY_TASK_ID}');
vid.FrameRate=4;
c_video_oned_immune


figure(2)
clf
U_sum=sum(U);
I_sum=sum(I);
T_sum=sum(Tcell);

u1_sum=sum(u1')*dx;
u2_sum=sum(u2')*dx;
u3_sum=sum(u3')*dx;

plot(0:T_pde,U_sum,'LineWidth',2)
hold on
plot(0:T_pde,I_sum,'LineWidth',2)
hold on
plot(0:T_pde,U_sum+I_sum,'LineWidth',2)
hold on
plot(0:T_pde,T_sum,'LineWidth',2)
hold on
plot(0:T_pde,u1_sum,'k:','LineWidth',2)
hold on
plot(0:T_pde,u2_sum,'k:','LineWidth',2)
hold on
plot(0:T_pde,u1_sum+u2_sum,'k:','LineWidth',2)
hold on
plot(0:T_pde,u3_sum,'k:','LineWidth',2)
axis([0 T_pde 0 max(u1_sum+u2_sum)])

legend('Uninfected','Infected','Total','Immune','Location','northwest')


